<?php
session_start();
require 'config.php';

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';
$role = $_POST['role'] ?? '';

$stmt = $conn->prepare("SELECT id, username, password, role FROM users WHERE username=? AND role=? LIMIT 1");
$stmt->bind_param("ss", $username, $role);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
if($user && password_verify($password, $user['password'])){
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['username'] = $user['username'];
    $_SESSION['role'] = $user['role'];
    if($role==='admin') header('Location: ../admin_dashboard.php');
    else header('Location: ../staff_dashboard.php');
} else {
    header('Location: ../login.html?error=Invalid credentials');
}
exit;
?>
