<?php
header('Content-Type: application/json');
require 'config.php';

// expects POST: action=add/edit, id (for edit), name, emp_id, role
$input = $_POST;
$action = $input['action'] ?? '';
$name = trim($input['name'] ?? '');
$emp_id = trim($input['emp_id'] ?? '');
$role = trim($input['role'] ?? '');

if ($name === '' || $emp_id === '') {
  echo json_encode(['ok' => false, 'msg' => 'Name and Employee ID required']);
  exit;
}

$raw = file_get_contents(EMP_FILE);
$employees = json_decode($raw, true);
if (!is_array($employees)) $employees = [];

if ($action === 'add') {
  // generate simple uid
  $id = time() . rand(100,999);
  $employees[$id] = ['id' => $id, 'name' => $name, 'emp_id' => $emp_id, 'role' => $role];
  file_put_contents(EMP_FILE, json_encode($employees, JSON_PRETTY_PRINT), LOCK_EX);
  echo json_encode(['ok' => true, 'msg' => 'Employee added', 'employee' => $employees[$id]]);
  exit;
}

if ($action === 'edit') {
  $id = $input['id'] ?? '';
  if (!$id || !isset($employees[$id])) {
    echo json_encode(['ok' => false, 'msg' => 'Employee not found']); exit;
  }
  $employees[$id]['name'] = $name;
  $employees[$id]['emp_id'] = $emp_id;
  $employees[$id]['role'] = $role;
  file_put_contents(EMP_FILE, json_encode($employees, JSON_PRETTY_PRINT), LOCK_EX);
  echo json_encode(['ok' => true, 'msg' => 'Employee updated', 'employee' => $employees[$id]]);
  exit;
}

echo json_encode(['ok' => false, 'msg' => 'Invalid action']);
