<?php
header('Content-Type: application/json');
require 'config.php';

// POST: emp_id (employee unique id from employees.json), type = in|out
$emp_id = $_POST['emp_id'] ?? '';
$type = $_POST['type'] ?? '';
if (!$emp_id || !in_array($type,['in','out'])) { echo json_encode(['ok'=>false,'msg'=>'Invalid']); exit; }

$rawEmp = file_get_contents(EMP_FILE);
$employees = json_decode($rawEmp, true);
if (!isset($employees[$emp_id])) { echo json_encode(['ok'=>false,'msg'=>'Employee not found']); exit; }

$raw = file_get_contents(ATT_FILE);
$att = json_decode($raw, true);
if (!is_array($att)) $att = [];

$now = new DateTime('now');
$ip = $_SERVER['REMOTE_ADDR'] ?? '';

$rec = [
  'id' => time() . rand(100,999),
  'emp_id' => $emp_id,
  'name' => $employees[$emp_id]['name'],
  'emp_code' => $employees[$emp_id]['emp_id'],
  'type' => $type,
  'timestamp' => $now->format(DateTime::ATOM),
  'date' => $now->format('Y-m-d'),
  'time' => $now->format('H:i:s'),
  'ip' => $ip
];

$att[] = $rec;
file_put_contents(ATT_FILE, json_encode($att, JSON_PRETTY_PRINT), LOCK_EX);

echo json_encode(['ok'=>true,'msg'=>'Saved','record'=>$rec]);
