<?php
require 'config.php';
$raw = file_get_contents(ATT_FILE);
$att = json_decode($raw, true);
if (!is_array($att)) $att = [];

// optional filters via GET: start, end (YYYY-MM-DD)
$start = $_GET['start'] ?? '';
$end = $_GET['end'] ?? '';
$rows = [];
foreach ($att as $r) {
  if ($start && $r['date'] < $start) continue;
  if ($end && $r['date'] > $end) continue;
  $rows[] = $r;
}

$filename = 'attendance_' . date('Ymd_His') . '.csv';
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="' . $filename . '"');
$out = fopen('php://output', 'w');
fputcsv($out, ['id','emp_code','name','type','date','time','ip','timestamp']);
foreach ($rows as $r) fputcsv($out, [$r['id'],$r['emp_code'],$r['name'],$r['type'],$r['date'],$r['time'],$r['ip'] ?? '',$r['timestamp']]);
fclose($out);
exit;
