<?php
session_start();
require 'api/config.php';

$login_error = '';
// handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'login') {
    $u = $_POST['username'] ?? '';
    $p = $_POST['password'] ?? '';
    if ($u === ADMIN_USER && $p === ADMIN_PASS) {
        $_SESSION['admin'] = true;
        header('Location: admin.php');
        exit;
    } else {
        $login_error = 'Invalid credentials';
    }
}

// handle logout
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    session_destroy();
    header('Location: admin.php');
    exit;
}

$logged_in = isset($_SESSION['admin']) && $_SESSION['admin'] === true;
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Attendance - Admin</title>
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
  <div class="container">
<?php if (!$logged_in): ?>
    <header><h1>Admin Login</h1></header>
    <section class="card">
      <form method="post" action="admin.php">
        <input type="hidden" name="action" value="login">
        <div class="form-row" style="flex-direction:column;align-items:flex-start">
          <label>Username</label>
          <input name="username" placeholder="username">
          <label>Password</label>
          <input name="password" type="password" placeholder="password">
          <button class="btn" style="margin-top:8px">Login</button>
          <p class="muted"><?php echo htmlspecialchars($login_error); ?></p>
        </div>
      </form>
    </section>
<?php else: ?>
    <header>
      <h1>Admin Dashboard</h1>
      <div>
        <a class="btn small" href="index.html">Staff</a>
        <a class="btn small" href="admin.php?action=logout">Logout</a>
      </div>
    </header>

    <section class="card">
      <h2>Add Employee</h2>
      <div class="form-row">
        <input id="empName" placeholder="Full name">
        <input id="empCode" placeholder="Employee code/id">
        <input id="empRole" placeholder="Role (optional)">
        <button id="addEmp" class="btn">Add</button>
      </div>
      <p id="empMsg" class="muted"></p>
    </section>

    <section class="card">
      <h2>Employees</h2>
      <table id="empTable">
        <thead><tr><th>Name</th><th>Code</th><th>Role</th><th>Actions</th></tr></thead>
        <tbody></tbody>
      </table>
    </section>

    <section class="card">
      <h2>Attendance</h2>
      <div class="form-row">
        <label>Filter:</label>
        <input type="date" id="startDate"> to <input type="date" id="endDate">
        <button id="filterBtn" class="btn">Filter</button>
        <button id="exportBtn" class="btn">Export CSV</button>
      </div>
      <table id="attTable">
        <thead><tr><th>Date</th><th>Time</th><th>Emp Code</th><th>Name</th><th>Type</th><th>IP</th></tr></thead>
        <tbody></tbody>
      </table>
    </section>
<?php endif; ?>
  </div>
  <script src="assets/js/app.js"></script>
  <?php if ($logged_in): ?>
  <script>AttendanceApp.initAdmin();</script>
  <?php endif; ?>
</body>
</html>
